<?php

// JSON を受け取る
$raw = file_get_contents("php://input");
$data = json_decode($raw, true);

if (!is_array($data)) {
  http_response_code(400);
  exit("Invalid JSON");
}

if (empty($data["bean"]) || empty($data["method"])) {
  http_response_code(400);
  exit("Missing fields");
}

// 保存ディレクトリ
$dir = __DIR__ . "/../data";
if (!is_dir($dir)) {
  mkdir($dir, 0700, true);
}

// ファイル名
$filename = date("Ymd_His") . ".json";
$path = $dir . "/" . $filename;

// 保存データ整形
$record = [
  "date"    => date("Y-m-d H:i"),
  "bean"    => $data["bean"],
  "roast"   => $data["roast"],
  "method"  => $data["method"],
  "shop"  => $data["shop"],
  "comment" => $data["comment"] ?? ""
];

// --- ここから追加：文字数制限バリデーション ---
if (
    mb_strlen($record["bean"]) > 20 || 
    mb_strlen($record["roast"]) > 20 || 
    mb_strlen($record["method"]) > 20 || 
    mb_strlen($record["shop"]) > 20 || 
    mb_strlen($record["comment"]) > 30
) {
    http_response_code(400);
    exit("TEXT_TOO_LONG");
}
// --- ここまで追加 ---

// JSON 保存
//file_put_contents(
//  $path,
//  json_encode($record, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT)
//);

$result = file_put_contents(
  $path,
  json_encode($record, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT)
);

if ($result === false) {
  http_response_code(500);
  echo "WRITE_FAILED: " . $path;
  exit;
}


echo "OK";