<?php

// data ディレクトリ（api/ から 1つ上）
$dataDir = __DIR__ . "/../data";

// JSONファイル一覧を取得
$files = glob($dataDir . "/*.json");

$results = [];

// 各JSONファイルを読み込む
foreach ($files as $file) {
    $json = file_get_contents($file);
    if ($json === false) {
        continue;
    }

    $record = json_decode($json, true);
    if (!is_array($record)) {
        continue;
    }

    $results[] = $record;
}

// JSONとして返す
header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
header("Pragma: no-cache");
header("Content-Type: application/json; charset=UTF-8");
echo json_encode(
    $results,
    JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT
);

